// $Id: CImageLabel.cpp,v 1.4 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CImageLabel.hpp"
using Exponent::GUI::Controls::CImageLabel;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CImageLabel, CControl);

//	===========================================================================
CImageLabel::CImageLabel(IControlRoot *root, const long uniqueId, const CRect &area) 
		   : CControl(root, uniqueId, area, NULL)
{
	EXPONENT_CLASS_CONSTRUCTION(CImageLabel);
	this->controlIsMouseEnabled(false);
}

//	===========================================================================
CImageLabel::~CImageLabel() 
{ 
	EXPONENT_CLASS_DESTRUCTION(CImageLabel);
}

//	===========================================================================
void CImageLabel::drawControl(CGraphics &graphics)
{
	// Should we draw?
	if (!this->drawEnabledControl(graphics))
	{
		return;
	}

	// Draw the image
	this->drawPrimaryImage(graphics, m_doDefaultDrawing);
}